from manim import *
config.background_color = WHITE

class CoordSysExample(Scene):
    def construct(self):
        # the location of the ticks depends on the x_range and y_range.
        grid = Axes(
            x_range=[0, 1, 0.05],  # step size determines num_decimal_places.
            y_range=[0, 1, 0.05],
            x_length=9,
            y_length=5.5,
            axis_config={
                "numbers_to_include": np.arange(0, 1 + 0.1, 0.1),
                "number_scale_value": 0.5,
                "color": BLACK
            },
            tips=False,
        )
        self.add(grid)
        grid.get_axes().set_color(BLACK)

        graphs = VGroup()
        # Extra lines and labels for point (1,1)
        graphs += grid.get_horizontal_line(grid.c2p(1, 1, 0), color=BLACK)
        graphs += grid.get_vertical_line(grid.c2p(1, 1, 0), color=BLACK)
        #graphs += Dot(point=grid.c2p(1, 1, 0), color=RED)
        #graphs += Tex("(1,1)").scale(0.75).next_to(grid.c2p(1, 1, 0))
        self.add(graphs)

        # Labels for the x-axis and y-axis.
        #y_label = grid.get_y_axis_label("y", edge=LEFT, direction=LEFT, buff=0.4)
        #y_label.set_color(BLUE)
        #x_label = grid.get_x_axis_label("x")
        #x_label.set_color(BLUE)
        #grid_labels = VGroup(x_label, y_label)
        #self.add(grid_labels)
        self.wait(1)

        square = Square().set_fill(BLUE, opacity=1.0)
        self.add(square)
        self.play(FadeIn(square))
        self.wait(1)

        # animate the change of color
        #self.play(ApplyMethod(square.set_fill, BLUE))
        #self.wait(1)

        # animate the change of position
        self.play(ApplyMethod(square.shift, UP*1.5))
        self.wait(1)
        self.play(ApplyMethod(square.shift, LEFT*2))
        self.wait(1)
        self.play(ApplyMethod(square.shift, DOWN*2))
        self.wait(1)
        self.play(ApplyMethod(square.shift, RIGHT*2.5))
        self.wait(1)
        #dot = Dot([square.get_corner(), 0.5, 0])
        #dot2 = Dot([2, 0.5, 0])
        #line = Line(dot.get_center(), dot2.get_center()).set_color(BLACK)
        #b1 = Brace(line)
        #b1text = b1.get_text("Horizontal distance")
        #b1.set_color(BLACK)
        #b1text.set_color(BLACK)

        #self.add(line,b1,b1text)
        self.play(square.animate.set_fill(RED))
        self.wait(1)
