from manim import *
from manim import DARK_GREY, LIGHT_GREY, BLUE, PURPLE
config.background_color = WHITE

class sim(Scene):
    def construct(self):
        # erste stufe
        line1 = Line([-2, 0, 0], [1,1.5,0])
        line2 = Line([-2, 0, 0], [1,0.5,0])
        line3 = Line([-2, 0, 0], [1,-0.5,0])
        line4 = Line([-2, 0, 0], [1,-1.5,0])
        line1.set_stroke(BLACK, width=1.5)
        line2.set_stroke(BLACK, width=1.5)
        line3.set_stroke(BLACK, width=1.5)
        line4.set_stroke(BLACK, width=1.5)
        dot1 = Dot(point=[1,1.5,0], color='BLACK')
        dot2 = Dot(point=[1,0.5,0], color='BLACK')
        dot3 = Dot(point=[1,-0.5,0], color='BLACK')
        dot4 = Dot(point=[1,-1.5,0], color='BLACK')
        self.play(FadeIn(line1))
        self.wait(0.5)
        self.play(FadeIn(line2))
        self.wait(0.5)
        self.play(FadeIn(line3))
        self.wait(0.5)
        self.play(FadeIn(line4))
        self.wait(0.5)
        self.play(FadeIn(dot1,dot2,dot3,dot4))
        self.wait(2.5)

        # Ergebnisse
        tex1 = MathTex(r"\omega_1", color=BLACK).scale(1)
        tex2 = MathTex(r"\omega_2", color=BLACK).scale(1)
        tex3 = MathTex(r"\omega_3", color=BLACK).scale(1)
        tex4 = MathTex(r"\omega_4", color=BLACK).scale(1)
        tex1.move_to([1.5,1.5,0])
        tex2.move_to([1.5,0.5,0])
        tex3.move_to([1.5,-0.5,0])
        tex4.move_to([1.5,-1.5,0])
        self.play(FadeIn(tex1))
        self.play(FadeIn(tex2))
        self.play(FadeIn(tex3))
        self.play(FadeIn(tex4))


        # Mensch ärgere dich nicht
        self.play(FadeOut(tex1),FadeOut(tex2),FadeOut(tex3),FadeOut(tex4),
        FadeOut(line1),FadeOut(line2),FadeOut(line3),FadeOut(line4),
        FadeOut(dot1),FadeOut(dot2),FadeOut(dot3),FadeOut(dot4))

        # erste stufe
        line1 = Line([-4, 0, 0], [-1,2.5,0])
        line2 = Line([-4, 0, 0], [-1,1.5,0])
        line3 = Line([-4, 0, 0], [-1,0.5,0])
        line4 = Line([-4, 0, 0], [-1,-0.5,0])
        line5 = Line([-4, 0, 0], [-1,-1.5,0])
        line6 = Line([-4, 0, 0], [-1,-2.5,0])
        line1.set_stroke(BLACK, width=1.5)
        line2.set_stroke(BLACK, width=1.5)
        line3.set_stroke(BLACK, width=1.5)
        line4.set_stroke(BLACK, width=1.5)
        line5.set_stroke(BLACK, width=1.5)
        line6.set_stroke(BLACK, width=1.5)
        dot1 = Dot(point=[-1,2.5,0], color='BLACK')
        dot2 = Dot(point=[-1,1.5,0], color='BLACK')
        dot3 = Dot(point=[-1,0.5,0], color='BLACK')
        dot4 = Dot(point=[-1,-0.5,0], color='BLACK')
        dot5 = Dot(point=[-1,-1.5,0], color='BLACK')
        dot6 = Dot(point=[-1,-2.5,0], color='BLACK')
        self.wait(2)
        self.play(FadeIn(line1))
        self.wait(0.5)
        self.play(FadeIn(line2))
        self.wait(0.5)
        self.play(FadeIn(line3))
        self.wait(0.5)
        self.play(FadeIn(line4))
        self.wait(0.5)
        self.play(FadeIn(line5))
        self.wait(0.5)
        self.play(FadeIn(line6))
        self.wait(0.5)
        self.play(FadeIn(dot1,dot2,dot3,dot4,dot5,dot6))

        # Ergebnisse
        tex1 = MathTex(r"1", color=BLACK).scale(1)
        tex2 = MathTex(r"2", color=BLACK).scale(1)
        tex3 = MathTex(r"3", color=BLACK).scale(1)
        tex4 = MathTex(r"4", color=BLACK).scale(1)
        tex5 = MathTex(r"5", color=BLACK).scale(1)
        tex6 = MathTex(r"6", color=BLACK).scale(1)
        tex1.move_to([-0.5,2.5,0])
        tex2.move_to([-0.5,1.5,0])
        tex3.move_to([-0.5,0.5,0])
        tex4.move_to([-0.5,-0.5,0])
        tex5.move_to([-0.5,-1.5,0])
        tex6.move_to([-0.5,-2.5,0])
        self.play(FadeIn(tex1))
        self.play(FadeIn(tex2))
        self.play(FadeIn(tex3))
        self.play(FadeIn(tex4))
        self.play(FadeIn(tex5))
        self.play(FadeIn(tex6))
        self.wait(7)

        texb = MathTex(r"P(\{i\})=1/6 \text{ für }i=1,...,6", color=BLACK).scale(0.7)
        texb.move_to([-2.5,-3.5,0])
        self.play(FadeIn(texb))
        self.wait(3)

        line7 = Line([2, 0, 0], [5,0.5,0])
        line8 = Line([2, 0, 0], [5,-0.5,0])
        line7.set_stroke(BLACK, width=1.5)
        line8.set_stroke(BLACK, width=1.5)
        dot7 = Dot(point=[5,0.5,0], color='BLACK')
        dot8 = Dot(point=[5,-0.5,0], color='BLACK')
        self.play(FadeIn(line7))
        self.wait(0.5)
        self.play(FadeIn(line8))
        self.wait(0.5)
        self.play(FadeIn(dot7,dot8))

        # Ergebnisse
        tex7 = MathTex(r"\neg 6", color=BLACK).scale(1)
        tex8 = MathTex(r"6", color=BLACK).scale(1)
        tex7.move_to([5.5,-0.5,0])
        tex8.move_to([5.5,0.5,0])
        self.play(FadeIn(tex7))
        self.play(FadeIn(tex8))
        self.wait(2)

        texc = MathTex(r"P(\{6\})=1/6, P(\{ \neg 6\})=5/6", color=BLACK).scale(0.7)
        texc.move_to([4,-2.5,0])
        self.play(FadeIn(texc))
        self.wait(5)

        self.play(FadeOut(tex1),FadeOut(tex2),FadeOut(tex3),FadeOut(tex4),FadeOut(tex5),FadeOut(tex6),FadeOut(tex7),FadeOut(tex8),
        FadeOut(line1),FadeOut(line2),FadeOut(line3),FadeOut(line4),FadeOut(line5),FadeOut(line6),FadeOut(line7),FadeOut(line8),FadeOut(dot1),FadeOut(dot2),FadeOut(dot3),FadeOut(dot4),
        FadeOut(dot5),FadeOut(dot6),FadeOut(dot7),FadeOut(dot8),FadeOut(texb),FadeOut(texc))


        # Zurück zum Hauptbeispiel
        # erste stufe
        line1 = Line([-2, 0, 0], [1,1.5,0])
        line2 = Line([-2, 0, 0], [1,0.5,0])
        line3 = Line([-2, 0, 0], [1,-0.5,0])
        line4 = Line([-2, 0, 0], [1,-1.5,0])
        line1.set_stroke(BLACK, width=1.5)
        line2.set_stroke(BLACK, width=1.5)
        line3.set_stroke(BLACK, width=1.5)
        line4.set_stroke(BLACK, width=1.5)
        dot1 = Dot(point=[1,1.5,0], color='BLACK')
        dot2 = Dot(point=[1,0.5,0], color='BLACK')
        dot3 = Dot(point=[1,-0.5,0], color='BLACK')
        dot4 = Dot(point=[1,-1.5,0], color='BLACK')

        # Ergebnisse
        tex1 = MathTex(r"\omega_1", color=BLACK).scale(1)
        tex2 = MathTex(r"\omega_2", color=BLACK).scale(1)
        tex3 = MathTex(r"\omega_3", color=BLACK).scale(1)
        tex4 = MathTex(r"\omega_4", color=BLACK).scale(1)
        tex1.move_to([1.5,1.5,0])
        tex2.move_to([1.5,0.5,0])
        tex3.move_to([1.5,-0.5,0])
        tex4.move_to([1.5,-1.5,0])
        self.play(FadeIn(line1),FadeIn(line2),FadeIn(line3),FadeIn(line4),
        FadeIn(dot1),FadeIn(dot2),FadeIn(dot3),FadeIn(dot4),
        FadeIn(tex1),FadeIn(tex2),FadeIn(tex3),FadeIn(tex4))

        # Texte an Ästen
        tex5 = MathTex(r"P(\{ \omega_1 \})", color=BLACK).scale(0.5)
        tex6 = MathTex(r"P(\{ \omega_2 \})", color=BLACK).scale(0.5)
        tex7 = MathTex(r"P(\{ \omega_3 \})", color=BLACK).scale(0.5)
        tex8 = MathTex(r"P(\{ \omega_4 \})", color=BLACK).scale(0.5)
        tex5.move_to([-0.5,1.1,0]).rotate(PI/7)
        tex6.move_to([-0.4,0.5,0]).rotate(PI/15)
        tex7.move_to([-0.4,0,0]).rotate(-PI/21)
        tex8.move_to([-0.5,-0.5,0]).rotate(-PI/8)
        self.play(FadeIn(tex5))
        self.play(FadeIn(tex6))
        self.play(FadeIn(tex7))
        self.play(FadeIn(tex8))
        self.wait(10)

        self.play(line1.animate.set_stroke(BLUE, width=4),dot1.animate.set_fill(BLUE),
        line2.animate.set_stroke(BLUE, width=4),dot2.animate.set_fill(BLUE),
        line3.animate.set_stroke(BLUE, width=4),dot3.animate.set_fill(BLUE),
        line4.animate.set_stroke(BLUE, width=4),dot4.animate.set_fill(BLUE))
        self.wait(2)
        self.play(Indicate(tex5,color=BLUE),Indicate(tex6,color=BLUE),
        Indicate(tex7,color=BLUE),Indicate(tex8,color=BLUE))
        self.play(line1.animate.set_stroke(BLACK, width=1.5),dot1.animate.set_fill(BLACK),
        line2.animate.set_stroke(BLACK, width=1.5),dot2.animate.set_fill(BLACK),
        line3.animate.set_stroke(BLACK, width=1.5),dot3.animate.set_fill(BLACK),
        line4.animate.set_stroke(BLACK, width=1.5),dot4.animate.set_fill(BLACK))
        self.wait(19)

        self.play(FadeOut(tex6))
        tex9 = MathTex(r"P(\{ \omega_2 \})=?", color=BLACK).scale(0.5)
        tex9.move_to([-0.4,0.5,0]).rotate(PI/15)
        self.play(FadeIn(tex9))
        self.wait(4)

        tex10 = MathTex(r"P(\{ \omega_2 \})=1-(P(\{ \omega_1 \})+P(\{ \omega_3 \})+P(\{ \omega_4 \}))", color=BLACK).scale(0.8)
        tex10.move_to([-0.5,-2.5,0])
        self.play(FadeIn(tex10))
        self.wait(5)

        self.play(FadeOut(tex10,tex9))
        self.play(FadeIn(tex6))
        self.wait(10)


        self.play(line2.animate.set_stroke(BLUE, width=4),dot2.animate.set_fill(BLUE),
        line3.animate.set_stroke(BLUE, width=4),dot3.animate.set_fill(BLUE))
        self.play(Indicate(tex6,color=BLUE),Indicate(tex7,color=BLUE))

        self.play(line2.animate.set_stroke(BLACK, width=1.5),dot2.animate.set_fill(BLACK),
        line3.animate.set_stroke(BLACK, width=1.5),dot3.animate.set_fill(BLACK))
        #framebox1 = SurroundingRectangle(tex6, buff = .1, color = BLUE)
        #framebox2 = SurroundingRectangle(tex7, buff = .1, color = BLUE)
        #self.play(
        #    Create(framebox1),
        #)
        #self.play(
        #    Create(framebox2),
        #)

        tex12 = MathTex(r"P(\{\omega_2,\omega_3\})=P(\{ \omega_2 \})+P(\{ \omega_3 \})", color=BLACK).scale(0.9)
        tex12.move_to([0,-2.5,0])
        self.play(FadeIn(tex12))
        self.wait(2)
        self.play(Indicate(tex12,color=BLUE))
        self.wait(7)
        self.play(FadeOut(tex12))

        self.wait(3)
        self.play(Indicate(tex1,color=BLUE))
        self.play(Indicate(tex2,color=BLUE))
        self.play(Indicate(tex3,color=BLUE))
        self.play(Indicate(tex4,color=BLUE))

        tex11 = MathTex(r"\Omega=\{\omega_1,\omega_2,\omega_3,\omega_4\}", color=BLACK).scale(0.9)
        tex11.move_to([1,-2.5,0])
        self.play(FadeIn(tex11))
        self.wait(0.5)
        self.play(Indicate(tex1,color=BLUE),Indicate(tex2,color=BLUE),Indicate(tex3,color=BLUE),Indicate(tex4,color=BLUE),Indicate(tex11,color=BLUE))
        self.wait(4)
        #tex3= MathTex(r"\text{C}", color=BLACK).scale(1)
        #tex4 = MathTex(r"\text{D}", color=BLACK).scale(1)
        #tex3.move_to([0.25,1.25,0])
        #tex4.move_to([0.25,0.25,0])

        #tex5= MathTex(r"\text{E}", color=BLACK).scale(1)
        #tex6 = MathTex(r"\text{F}", color=BLACK).scale(1)
        #tex5.move_to([0.25,-0.25,0])
        #tex6.move_to([0.25,-1.25,0])

        #tex7= MathTex(r"\mathbb{P}(A)", color=BLACK).scale(0.8)
        #tex8= MathTex(r"\mathbb{P}(B)", color=BLACK).scale(0.8)
        #tex7.move_to([-2.25,1,0])
        #tex8.move_to([-2.25,-1,0])


        #self.play(Create(line))
        #self.play(Create(line2))
        #self.play(FadeIn(tex1))
        #self.play(FadeIn(tex2))
        #self.play(Create(line3))
        #self.play(Create(line4))
        #self.play(Create(line5))
        #self.play(Create(line6))
        #self.play(FadeIn(tex3,tex4))
        #self.play(FadeIn(tex5,tex6))
        #self.play(FadeIn(tex7,tex8))
